import Utilities.gui_creator as gc
import Utilities.nidaq_operations as no
import threading
import time

root = gc.create_window(title='TMP36 Thermometer',
                        size='300x100')

channel_name = 'Dev1/ai0'
task = no.create_ai_task(channel_name)

lbl_2 = gc.create_indicator(root,
                            label_1='Temperature (deg C)')

def acquire_sample():

    while btn.cget('text') == 'Stop':
        float_data = task.read()
        temperature = 100*float_data - 50
        string_data = f'{temperature:.0f}'

        lbl_2.config(text=string_data)        

        time.sleep(0.1)

    return


def toggle():

    if btn.cget('text') == 'Start':
        btn.config(text='Stop')
    elif btn.cget('text') == 'Stop':
        btn.config(text='Start')

    t = threading.Thread(target=acquire_sample)
    t.start()

    return

btn = gc.action_button(root,label='Start',
                       action=toggle)

root.mainloop()

task.close()
